<?php namespace Visiosoft\DemandModule\Seed;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterOptionsRepeaterEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class FieldSeeder extends Seeder
{

    private $fieldRepository;
    private $assignmentRepository;
    private $streamRepository;

    public function __construct(
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        StreamRepositoryInterface $streamRepository
    )
    {
        parent::__construct();
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        $typesFields = [
            'min_budget' => [
                'name' => 'Min Budget',
                'types' => ['buy_house', 'buy_land'],
                'slug' => 'min_budget',
                'type' => 'anomaly.field_type.text',
                "config" => [
                    "type" => "text",
                    "max"  => 255,
                ]
            ],
            'max_budget' => [
                'name' => 'Max Budget',
                'types' => ['buy_house', 'buy_land'],
                'slug' => 'max_budget',
                'type' => 'anomaly.field_type.text',
                "config" => [
                    "type" => "text",
                    "max"  => 255,
                ]
            ],
            'time_frame' => [
                'name' => 'Time Frame',
                'types' => ['buy_house', 'buy_land', 'lend_land'],
                'slug' => 'time_frame',
                'type' => 'anomaly.field_type.relationship',
                "config" => [
                    "related"    => RepeaterOptionsRepeaterEntryModel::class,
                    "mode"       => "dropdown",
                    "title_name" => 'option_name',
                ]
            ]
        ];

        foreach ($typesFields as $typesField) {
            $field = $this->fieldRepository->findBySlugAndNamespace($typesField['slug'], 'demand');
            if ($field) {
                $field->delete();
            }
            $field = $this->fieldRepository->create([
                'name' => $typesField['name'],
                'namespace' => 'demand',
                'slug' => $typesField['slug'],
                'type' => $typesField['type'],
                'locked' => 0,
                "config" => $typesField['config']
            ]);
            foreach ($typesField['types'] as $type) {
                $stream = $this->streamRepository->findBySlugAndNamespace($type . '_demand', 'demand');
                $this->assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->id,
                    'label' => $typesField['name']
                ]);
            }
        }
    }
}
