<?php namespace Visiosoft\DemandModule\Demand\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class DemandTableBuilder extends TableBuilder
{
    protected $columns = [
        'id' => 'entry.id',
        'inquiry' => [
            'value' => 'entry.type.inquiry'
        ],
        'inquiry_type' => [
            'value' => 'entry.type.inquiry_type'
        ],
        'user' => [
            'value' => 'entry.user.name'
        ],
        'email' => [
            'value' => 'entry.user.email'
        ],
        'phone' => [
            'value' => 'entry.user.gsm_phone'
        ],
        'submitted_at' => [
            'value' => 'entry.created_at|date'
        ]
    ];

    protected $buttons = [
        'offer' => [
            'href' => '/offers/select?demand={entry.id}',
        ],
        'show' => [
            'type' => 'info'
        ],
        'edit',
    ];

    protected $actions = [
        'delete'
    ];

    protected $options = [
        'order_by' => [
            'id' => 'desc'
        ]
    ];
}
