<?php namespace Visiosoft\DemandModule\Demand\Form;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class DemandFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => UserModel::class,
                'handler' => 'Visiosoft\DemandModule\Demand\Form\UsersOptions@handle'
            ]
        ],
        '*',
    ];

    /**
     * The demand type.
     *
     * @var null|TypeInterface
     */
    protected $type = null;

    /**
     * Skip these fields.
     *
     * @var array
     */
    protected $skips = [
        'type',
        'entry',
    ];

    /**
     * Fired when the builder is ready to build.
     *
     * @throws \Exception
     */
    public function onReady()
    {
        if (!$this->getType() && !$this->getEntry()) {
            throw new \Exception('The $type parameter is required when creating a demand.');
        }
    }

    /**
     * Fired just before saving the form.
     */
    public function onSaving()
    {
        $entry  = $this->getFormEntry();
        $type   = $this->getType();

        if ($type) {
            $entry->type_id = $type->getId();
        }
    }

    /**
     * Get the type.
     *
     * @return TypeInterface|null
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Set the type.
     *
     * @param  TypeInterface $type
     * @return $this
     */
    public function setType(TypeInterface $type)
    {
        $this->type = $type;

        return $this;
    }
}
