<?php namespace Visiosoft\DemandModule\Demand\Form;

use Visiosoft\DemandModule\Demand\DemandModel;
use Anomaly\Streams\Platform\Addon\FieldType\FieldType;

class DemandEntryFormSections
{

    /**
     * Handle the form sections.
     *
     * @param DemandEntryFormBuilder $builder
     */
    public function handle(DemandEntryFormBuilder $builder)
    {
        $builder->setSections(
            [
                'demand'   => [
                    'fields' => [
                        'demand_user',
                        'demand_country',
                        'demand_city',
                        'demand_district',
                        'demand_neighborhood'
                    ],
                ],
                'fields' => [
                    'fields' => function (DemandEntryFormBuilder $builder) {
                        return array_map(
                            function (FieldType $field) {
                                return 'entry_' . $field->getField();
                            },
                            array_filter(
                                $builder->getFormFields()->base()->all(),
                                function (FieldType $field) {
                                    return (!$field->getEntry() instanceof DemandModel);
                                }
                            )
                        );
                    },
                ],
            ]
        );
    }
}
