<?php namespace Visiosoft\DemandModule\Demand\Form\Command;

use Visiosoft\DemandModule\Entry\Form\EntryFormBuilder;
use Visiosoft\DemandModule\Demand\Contract\DemandInterface;
use Visiosoft\DemandModule\Demand\Form\DemandEntryFormBuilder;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;

class AddEntryFormFromDemand
{

    use DispatchesJobs;

    /**
     * The multiple form builder.
     *
     * @var DemandEntryFormBuilder
     */
    protected $builder;

    /**
     * The demand instance.
     *
     * @var DemandInterface
     */
    protected $demand;

    /**
     * Create a new AddEntryFormFromDemand instance.
     *
     * @param DemandEntryFormBuilder $builder
     * @param DemandInterface $demand
     */
    public function __construct(DemandEntryFormBuilder $builder, DemandInterface $demand)
    {
        $this->builder = $builder;
        $this->demand    = $demand;
    }

    /**
     * Handle the command.
     *
     * @param EntryFormBuilder $builder
     * @param TypeRepositoryInterface $types
     */
    public function handle(EntryFormBuilder $builder, TypeRepositoryInterface $types)
    {
        $type = $this->demand->getType();

        if (request()->has('type')) {

            $type = $types->find(request('type'));

            $this->builder->setOption('redirect', 'admin/demand/edit/' . $this->demand->getId());
        }

        $builder->setModel($type->getEntryModelName());
        $builder->setEntry($this->demand->getEntryId());

        $this->builder->addForm('entry', $builder);
    }
}
