<?php namespace Visiosoft\DemandModule\Demand\Form\Command;

use Visiosoft\DemandModule\Demand\Contract\DemandInterface;
use Visiosoft\DemandModule\Demand\Form\DemandEntryFormBuilder;
use Visiosoft\DemandModule\Demand\Form\DemandFormBuilder;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;

class AddDemandFormFromDemand
{

    use DispatchesJobs;

    /**
     * The multiple form builder.
     *
     * @var DemandEntryFormBuilder
     */
    protected $builder;

    /**
     * The demand instance.
     *
     * @var DemandInterface
     */
    protected $demand;

    /**
     * Create a new AddDemandFormFromDemand instance.
     *
     * @param DemandEntryFormBuilder $builder
     * @param DemandInterface        $demand
     */
    public function __construct(DemandEntryFormBuilder $builder, DemandInterface $demand)
    {
        $this->builder = $builder;
        $this->demand    = $demand;
    }

    /**
     * Handle the command.
     *
     * @param DemandFormBuilder $builder
     * @param TypeRepositoryInterface $types
     */
    public function handle(DemandFormBuilder $builder, TypeRepositoryInterface $types)
    {
        $builder->setEntry($this->demand->getId());

        if (request()->has('type')) {

            /* @var TypeInterface $type */
            $type = $types->find(request('type'));

            $builder->setType($type);
        }

        $this->builder->addForm('demand', $builder);
    }
}
