<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDemandCreateOptionsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'options',
        'title_column' => 'title',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'title' => [
            'unique' => true,
            'required' => true,
            'translatable' => true
        ],
        'options_slug' => [
            'required' => true,
        ],
        'related_type' => [
            'required' => true,
        ],
        'options' => [
            'required' => true,
        ],
        'step' => [
            'required' => true,
        ],
    ];

}
