<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDemandCreateDemandFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\UsersModule\User\UserModel::class
            ]
        ],
        'city' => 'anomaly.field_type.select',
        'district' => 'anomaly.field_type.select',
        'neighborhood' => 'anomaly.field_type.select',
        "type" => [
            "type"   => "anomaly.field_type.relationship",
            "config" => [
                "related" => \Visiosoft\DemandModule\Type\TypeModel::class,
            ]
        ],
        'inquiry' => 'anomaly.field_type.text',
        'inquiry_type' => 'anomaly.field_type.text',
        'type_slug'             => [
            'type'   => 'anomaly.field_type.slug',
            'config' => [
                'type'    => '_',
            ],
        ],
        "inquiry_logo" => [
            "type"   => "anomaly.field_type.file",
            "config" => [
                "folders"       => ['images'],
            ]
        ],
        'description'  => 'anomaly.field_type.textarea',
        'entry'            => 'anomaly.field_type.polymorphic',
        'step'            => 'anomaly.field_type.integer',
        'title' => 'anomaly.field_type.text',
        "related_type" => [
            "type"   => "anomaly.field_type.multiple",
            "config" => [
                "related" => \Visiosoft\DemandModule\Type\TypeModel::class,
                "title_name" => 'type_slug',
            ]
        ],
        'options_slug'             => [
            'type'   => 'anomaly.field_type.slug',
            'config' => [
                'slugify' => 'title',
                'type'    => '_',
            ],
        ],
        "options" => [
            "type"   => "anomaly.field_type.repeater",
            "config" => [
                "related"        => \Anomaly\Streams\Platform\Model\Repeater\RepeaterOptionsRepeaterEntryModel::class,
            ]
        ],
    ];

}
