<?php namespace Visiosoft\DemandModule\Type\Command;

use Illuminate\Support\Str;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Contracts\Config\Repository;
use Illuminate\Foundation\Bus\DispatchesJobs;

class UpdateStream
{

    use DispatchesJobs;

    /**
     * The demand type instance.
     *
     * @var TypeInterface
     */
    protected $type;

    /**
     * Update a new UpdateStream instance.
     *
     * @param TypeInterface $type
     */
    public function __construct(TypeInterface $type)
    {
        $this->type = $type;
    }

    /**
     * Handle the command.
     *
     * @param StreamRepositoryInterface $streams
     * @param TypeRepositoryInterface   $types
     * @param Repository                $config
     */
    public function handle(StreamRepositoryInterface $streams, TypeRepositoryInterface $types, Repository $config)
    {
        /* @var TypeInterface $type */
        if (!$type = $types->find($this->type->getId())) {
            return;
        }

        /* @var StreamInterface $stream */
        $stream = $type->getEntryStream();

        $stream->fill(
            [
                $config->get('app.fallback_locale') => [
                    'name'        => $this->type->getInquiry() . ' ' . $this->type->getInquiryType(),
                    'description' => $this->type->getDescription(),
                ],
                'slug' => $this->type->type_slug . '_demand',
            ]
        );

        $streams->save($stream);
    }
}
