<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDemandCreateServicesStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'services',
        'title_column' => 'user_id',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'user' => [
            'required' => true,
        ],
        "type" => [
            'required' => true,
        ],
        'entry',
    ];

}
