<?php namespace Visiosoft\DemandModule\Service;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\DemandModule\Service\Contract\ServiceInterface;
use Anomaly\Streams\Platform\Model\Demand\DemandServicesEntryModel;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;

class ServiceModel extends DemandServicesEntryModel implements ServiceInterface
{

    /**
     * Get the service type.
     *
     * @return null|TypeInterface
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the related entry.
     *
     * @return EntryInterface
     */
    public function getEntry()
    {
        return $this->entry;
    }

    /**
     * Get the related entry's ID.
     *
     * @return null|int
     */
    public function getEntryId()
    {
        $entry = $this->getEntry();

        return $entry->getId();
    }
}
