<?php namespace Visiosoft\DemandModule\Http\Controller;

use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Image\Image;
use Anomaly\Streams\Platform\Model\Demand\DemandTypesEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterOptionsRepeaterEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Visiosoft\DemandModule\Demand\Contract\DemandRepositoryInterface;
use Visiosoft\DemandModule\Option\Contract\OptionRepositoryInterface;
use Visiosoft\DemandModule\Service\Contract\ServiceRepositoryInterface;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;
use Visiosoft\LocationModule\District\Contract\DistrictRepositoryInterface;
use Visiosoft\LocationModule\Neighborhood\Contract\NeighborhoodRepositoryInterface;

class ApiController extends PublicController
{
    private $image;
    private $cityRepository;
    private $districtRepository;
    private $neighborhoodRepository;
    private $demandTypesEntryTranslationsModel;
    private $typeRepository;
    private $optionRepository;
    private $optionsRepeaterEntryModel;
    private $streamRepository;
    private $demandRepository;
    private $userRepository;
    private $serviceRepository;
    private $fieldRepository;

    public function __construct(
        Image $image,
        CityRepositoryInterface $cityRepository,
        DistrictRepositoryInterface $districtRepository,
        NeighborhoodRepositoryInterface $neighborhoodRepository,
        DemandTypesEntryTranslationsModel $demandTypesEntryTranslationsModel,
        TypeRepositoryInterface $typeRepository,
        OptionRepositoryInterface $optionRepository,
        RepeaterOptionsRepeaterEntryModel $optionsRepeaterEntryModel,
        StreamRepositoryInterface $streamRepository,
        DemandRepositoryInterface $demandRepository,
        UserRepositoryInterface $userRepository,
        ServiceRepositoryInterface $serviceRepository,
        FieldRepositoryInterface $fieldRepository
    )
    {
        parent::__construct();

        $this->image = $image;
        $this->cityRepository = $cityRepository;
        $this->districtRepository = $districtRepository;
        $this->neighborhoodRepository = $neighborhoodRepository;
        $this->demandTypesEntryTranslationsModel = $demandTypesEntryTranslationsModel;
        $this->typeRepository = $typeRepository;
        $this->optionRepository = $optionRepository;
        $this->optionsRepeaterEntryModel = $optionsRepeaterEntryModel;
        $this->streamRepository = $streamRepository;
        $this->demandRepository = $demandRepository;
        $this->userRepository = $userRepository;
        $this->serviceRepository = $serviceRepository;
        $this->fieldRepository = $fieldRepository;
    }

//    public function getImage()
//    {
//        $image = $this->image->make($this->request->path, 'path');
//        dd($image->url());
//
//        return $image->url();
//    }

    public function getInquiries()
    {
        $inquiries = DB::table('demand_types')
            ->groupBy(DB::raw("SUBSTRING_INDEX(type_slug, '_', 1)"))->get();

        $inquiries = $this->typeRepository
            ->newQuery()
            ->whereIn('id', array_column($inquiries->toArray(), 'id'))
            ->get();

        $inquiryTypes = $this->getInquiryTypes($inquiries[0]->type_slug);

        return [
            'inquiries' => $inquiries,
            'inquiryTypes' => $inquiryTypes,
        ];
    }

    public function getInquiryTypes($slug = null)
    {
        if (is_null($slug)) {
            $slug = $this->request->slug;
        }
        $slug = explode('_', $slug)[0];

        $inquiryTypes = $this->typeRepository->newQuery()
            ->where('type_slug', 'LIKE', "$slug%")->get();

        foreach ($inquiryTypes as $inquiryType) {
            $inquiryType->setAttribute('logo_url', $inquiryType->inquiry_logo->url());
        }

        return $inquiryTypes;
    }

    public function getLocation()
    {
        if ($this->request->type == 'city') {
            $locations = $this->cityRepository->newQuery()
                ->where('parent_country_id', setting_value('visiosoft.module.location::default_country'))
                ->get();
        } elseif ($this->request->type == 'district') {
            $locations = $this->districtRepository->newQuery()
                ->where('parent_city_id', $this->request->id)->get();
        } elseif ($this->request->type == 'neighborhood') {
            $locations = $this->neighborhoodRepository->newQuery()
                ->where('parent_district_id', $this->request->id)->get();
        }

        return $locations;
    }

    public function getOptions()
    {
        $inquiryType = $this->typeRepository
            ->findBy('type_slug', $this->request->inquirySlug);

        $relatedOptions = DB::table('demand_options_related_type')
            ->where('related_id', $inquiryType->id)->get();

        if (count($relatedOptions)) {
            $optionNames = $this->optionRepository->newQuery()
                ->whereIn('demand_options.id', array_column($relatedOptions->toArray(), 'entry_id'))
                ->get();

            $totalOptions = array();
            foreach ($optionNames as $optionName) {
                $relatedOptions = DB::table('demand_options_options')->select('related_id')
                    ->where('entry_id', $optionName->id)->get();
                $relatedOptions = array_column($relatedOptions->toArray(), 'related_id');

                $options = $this->optionsRepeaterEntryModel->newQuery()->whereIn('id', $relatedOptions)->get();
                foreach ($options as $option) {
                    $option->setAttribute('option_photo_url', $option->option_photo->url());
                }

                $totalOptions[$optionName->step] = [
                    'title' => $optionName->title,
                    'slug' => $optionName->options_slug,
                    'options' => $options,
                ];
            }

            return $totalOptions;
        }

        return 0;
    }

    public function submitDemand()
    {
        $allFields = $this->request->all();
        $userFields = $allFields[0];
        $fields = $allFields[1];

        // Check user
        $user = $this->checkUser($userFields['fullName'], $userFields['email'], $userFields['phone']);

        // Get demand type
        $inquiryType = $this->typeRepository->findBy('type_slug', $fields['demand']['inquirySlug']);

        // Check if service
        if (strpos($fields['demand']['inquirySlug'], 'services') !== false) {
            // Create a service
            $service = $this->serviceRepository->create([
                'user_id' => $user->id,
                'type_id' => $inquiryType->id,
            ]);

            // Create service custom fields
            $entryModel = $inquiryType->getEntryModel();
            $entry = $entryModel->create($fields['service']);
            $service->update([
                'entry_id' => $entry->id,
                'entry_type' => get_class($entry),
            ]);
        } else {
            // Create a demand
            $demand = $this->demandRepository->create([
                'user_id' => $user->id,
                'city' => $fields['location']['city'],
                'district' => $fields['location']['district'],
                'neighborhood' => $fields['location']['neighborhood'],
                'type_id' => $inquiryType->id,
            ]);

            unset($fields['demand']['inquirySlug']);

            // Create demand custom fields
            $entryModel = $inquiryType->getEntryModel();
            $entry = $entryModel->create($fields['demand']);
            $demand->update([
                'entry_id' => $entry->id,
                'entry_type' => get_class($entry),
            ]);
        }
    }

    public function checkUser($name, $email, $phone)
    {
        $user = $this->userRepository->newQuery()->where('email', $email)
            ->orWhere('gsm_phone', $phone)->first();

        if (is_null($user)) {
            $fullName = explode(" ", $name);
            $lastName = isset($fullName[1]) ? $fullName[1] : null;
            $user = $this->userRepository->create([
                'username' => $name . Str::random(8),
                'first_name' => $fullName[0],
                'last_name' => $lastName,
                'display_name' => $name,
                'email' => $email,
                'activated' => 1,
                'gsm_phone' => $phone,
            ]);
            $password = Str::random(8);
            $user->setAttribute('password', $password);
            $this->userRepository->save($user);
        };

        return $user;
    }

    public function getServicesTranslations()
    {
        $fieldsSlug = ['service_type', 'to_where', 'from_where', 'credit_amount', 'address', 'details', 'service_area',
            'plot_no', 'block_no'];
        $fields = $this->fieldRepository->newQuery()->whereIn('slug', $fieldsSlug)->get();

        $fieldsNames = array();
        foreach ($fields as $field) {
            $fieldsNames[$field->slug] = $field->name;
        }

        return $fieldsNames;
    }

    public function getTranslations()
    {
        dd($this->request->all());
    }
}
