<?php namespace Visiosoft\DemandModule\Type\Contract;

use Visiosoft\DemandModule\Demand\DemandCollection;
use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;

interface TypeInterface extends EntryInterface
{

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getInquiry();

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getInquiryType();

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getDescription();

    /**
     * Get the related entry stream.
     *
     * @return StreamInterface
     */
    public function getEntryStream();

    /**
     * Get the related entry stream ID.
     *
     * @return int
     */
    public function getEntryStreamId();

    /**
     * Get the related entry model.
     *
     * @return EntryModel
     */
    public function getEntryModel();

    /**
     * Get the related entry model name.
     *
     * @return string
     */
    public function getEntryModelName();

    /**
     * Get the related demands.
     *
     * @return DemandCollection
     */
    public function getDemands();

    /**
     * Return the demands relationship.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function demands();
}
