<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDemandCreateDemandsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'demands',
        'title_column' => 'user_id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'user' => [
            'required' => true,
        ],
        'city' => [
            'required' => true,
        ],
        'district',
        'neighborhood',
        "type" => [
            'required' => true,
        ],
        'entry',
    ];

}
