<?php namespace Visiosoft\DemandModule\Demand\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\DB;

class UsersOptions
{

    public function handle(RelationshipFieldType $fieldType, UserRepositoryInterface $entries)
    {
        $fieldType->setOptions(
            $entries->newQuery()
                ->select(DB::raw("CONCAT_WS('', first_name, ' ', last_name, ' / ', gsm_phone, ' / ', email) AS name"), 'id')
                ->pluck('name', 'id')->all()
        );
    }
}
