<?php namespace Visiosoft\DemandModule\Demand\Form\Command;

use Visiosoft\DemandModule\Demand\Form\DemandEntryFormBuilder;
use Visiosoft\DemandModule\Demand\Form\DemandFormBuilder;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Illuminate\Http\Request;

class AddDemandFormFromRequest
{

    /**
     * The multiple form builder.
     *
     * @var DemandEntryFormBuilder
     */
    protected $builder;

    /**
     * Create a new AddDemandFormFromRequest instance.
     *
     * @param DemandEntryFormBuilder $builder
     */
    public function __construct(DemandEntryFormBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param TypeRepositoryInterface $types
     * @param DemandFormBuilder         $builder
     * @param Request                 $request
     */
    public function handle(TypeRepositoryInterface $types, DemandFormBuilder $builder, Request $request)
    {
        $this->builder->addForm('demand', $builder->setType($types->find($request->get('type'))));
    }
}
