<?php namespace Visiosoft\DemandModule\Type;

use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Visiosoft\DemandModule\Type\Command\GetStream;
use Visiosoft\DemandModule\Demand\DemandCollection;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Model\Demand\DemandTypesEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;

class TypeModel extends DemandTypesEntryModel implements TypeInterface
{

    /**
     * Always eager load these.
     *
     * @var array
     */
    protected $with = [
        'translations',
    ];

    protected $appends = ['image'];

    /**
     * The cascaded relations.
     *
     * @var array
     */
    protected $cascades = [
        'demands',
    ];

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getInquiry()
    {
        return $this->inquiry;
    }

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getInquiryType()
    {
        return $this->inquiry_type;
    }

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the related entry stream.
     *
     * @return StreamInterface
     */
    public function getEntryStream()
    {
        return $this->dispatch(new GetStream($this));
    }

    /**
     * Get the related entry stream ID.
     *
     * @return int
     */
    public function getEntryStreamId()
    {
        if (!$stream = $this->getEntryStream()) {
            return null;
        }

        return $stream->getId();
    }

    /**
     * Get the related entry model.
     *
     * @return EntryModel
     */
    public function getEntryModel()
    {
        $stream = $this->getEntryStream();

        return $stream->getEntryModel();
    }

    /**
     * Get the related entry model name.
     *
     * @return string
     */
    public function getEntryModelName()
    {
        $stream = $this->getEntryStream();

        return $stream->getEntryModelName();
    }

    /**
     * Get the related demands.
     *
     * @return DemandCollection
     */
    public function getDemands()
    {
        return $this->demands;
    }

    /**
     * Return the demands relationship.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function demands()
    {
        return $this->hasMany('Visiosoft\DemandModule\Demand\DemandModel', 'type_id');
    }

    public function getImageAttribute()
    {
        if (!$image = $this->type_image) {
            // Check if there is a type that has an image
            $typeRepository = app(TypeRepositoryInterface::class);
            $slug = explode('_', $this->type_slug)[0];

            if ($type = $typeRepository->getInquiryTypeImageBySlug($slug)) {
                $image = $type->type_image;
            }
        }

        if ($image) {
            return $image->make()->url();
        }

        return $this->dispatch(new MakeImageInstance('visiosoft.theme.base::images/no-image.png', 'img'))->url();
    }
}
