<?php namespace Visiosoft\DemandModule\Service\Form\Command;

use Visiosoft\DemandModule\Service\Contract\ServiceInterface;
use Visiosoft\DemandModule\Service\Form\ServiceEntryFormBuilder;
use Visiosoft\DemandModule\Service\Form\ServiceFormBuilder;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;

class AddServiceFormFromService
{

    use DispatchesJobs;

    /**
     * The multiple form builder.
     *
     * @var ServiceEntryFormBuilder
     */
    protected $builder;

    /**
     * The service instance.
     *
     * @var ServiceInterface
     */
    protected $service;

    /**
     * Create a new AddServiceFormFromService instance.
     *
     * @param ServiceEntryFormBuilder $builder
     * @param ServiceInterface        $service
     */
    public function __construct(ServiceEntryFormBuilder $builder, ServiceInterface $service)
    {
        $this->builder = $builder;
        $this->service    = $service;
    }

    /**
     * Handle the command.
     *
     * @param ServiceFormBuilder $builder
     * @param TypeRepositoryInterface $types
     */
    public function handle(ServiceFormBuilder $builder, TypeRepositoryInterface $types)
    {
        $builder->setEntry($this->service->getId());

        if (request()->has('type')) {

            /* @var TypeInterface $type */
            $type = $types->find(request('type'));

            $builder->setType($type);
        }

        $this->builder->addForm('service', $builder);
    }
}
