<?php namespace Visiosoft\DemandModule\Service\Form\Command;

use Visiosoft\DemandModule\Service\Form\ServiceEntryFormBuilder;
use Visiosoft\DemandModule\Service\Form\ServiceFormBuilder;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Illuminate\Http\Request;

class AddServiceFormFromRequest
{

    /**
     * The multiple form builder.
     *
     * @var ServiceEntryFormBuilder
     */
    protected $builder;

    /**
     * Create a new AddServiceFormFromRequest instance.
     *
     * @param ServiceEntryFormBuilder $builder
     */
    public function __construct(ServiceEntryFormBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param TypeRepositoryInterface $types
     * @param ServiceFormBuilder         $builder
     * @param Request                 $request
     */
    public function handle(TypeRepositoryInterface $types, ServiceFormBuilder $builder, Request $request)
    {
        $this->builder->addForm('service', $builder->setType($types->find($request->get('type'))));
    }
}
