<?php namespace Visiosoft\DemandModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Model\Repeater\RepeaterOptionsRepeaterEntryModel;
use Visiosoft\DemandModule\Demand\Contract\DemandInterface;
use Visiosoft\DemandModule\Demand\Contract\DemandRepositoryInterface;
use Visiosoft\DemandModule\Demand\Form\Command\AddEntryFormFromDemand;
use Visiosoft\DemandModule\Demand\Form\Command\AddEntryFormFromRequest;
use Visiosoft\DemandModule\Demand\Form\Command\AddDemandFormFromDemand;
use Visiosoft\DemandModule\Demand\Form\Command\AddDemandFormFromRequest;
use Visiosoft\DemandModule\Demand\Form\DemandEntryFormBuilder;
use Visiosoft\DemandModule\Demand\Table\DemandTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class DemandsController extends AdminController
{
    public function index(DemandTableBuilder $table) {
        return $table->render();
    }

    public function create(DemandEntryFormBuilder $form)
    {
        $form->setOption('heading', "visiosoft.module.demand::field");

        $this->dispatch(new AddEntryFormFromRequest($form));
        $this->dispatch(new AddDemandFormFromRequest($form));

        return $form->render();
    }

    public function edit(DemandRepositoryInterface $demands, DemandEntryFormBuilder $form, $id)
    {
        $form->setOption('heading', "visiosoft.module.demand::field");

        /* @var DemandInterface $demand */
        $demand = $demands->find($id);

        $this->dispatch(new AddDemandFormFromDemand($form, $demand)); // First
        $this->dispatch(new AddEntryFormFromDemand($form, $demand)); // Second

        return $form->render($demand);
    }

    public function show(DemandRepositoryInterface $demands, $id)
    {
        $demand = $demands->find($id);
        $otherFields = $demand->entry->getAssignments()->fieldSlugs();

        $customFields = array();
        foreach ($otherFields as $field) {
            $customFields[] = [
                'name' => $demand->entry->getField($field)->getName(),
                'value' => (function () use ($demand, $field) {
                    if ($demand->entry->$field instanceof RepeaterOptionsRepeaterEntryModel) {
                        return $demand->entry->$field->option_name;
                    } else {
                        return $demand->entry->$field;
                    }
                })()
            ];
        }

        return $this->view->make(
            'module::admin/demand/show', [
                'demand'  => $demand,
                'customFields'  => $customFields,
            ]
        );
    }

    public function delete(DemandRepositoryInterface $demands, $id)
    {
        $demands->delete($demand = $demands->find($id));

        $demand->entry->delete();

        return redirect()->back();
    }

    public function note(DemandRepositoryInterface $demands, $id)
    {
        $validated = request()->validate([
            'note' => 'required',
        ]);

        if (!$demand = $demands->find($id)) {
            abort(404);
        }

        $demand->update(['note' => request()->note]);

        $this->messages->success(trans('visiosoft.module.demand::message.note_added'));

        return redirect()->back();
    }
}
