<?php namespace Visiosoft\DemandModule;

use Anomaly\Streams\Platform\Model\Demand\DemandOptionsEntryModel;
use Visiosoft\DemandModule\Step\Contract\StepRepositoryInterface;
use Visiosoft\DemandModule\Step\StepRepository;
use Anomaly\Streams\Platform\Model\Demand\DemandStepsEntryModel;
use Visiosoft\DemandModule\Step\StepModel;
use Anomaly\Streams\Platform\Model\Demand\DemandServicesEntryModel;
use Visiosoft\DemandModule\Http\Controller\Admin\AssignmentsController;
use Visiosoft\DemandModule\Http\Controller\Admin\FieldsController;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Assignment\AssignmentRouter;
use Anomaly\Streams\Platform\Field\FieldRouter;
use Anomaly\Streams\Platform\Model\Demand\DemandTypesEntryModel;
use Visiosoft\DemandModule\Demand\Contract\DemandRepositoryInterface;
use Visiosoft\DemandModule\Demand\DemandRepository;
use Anomaly\Streams\Platform\Model\Demand\DemandDemandsEntryModel;
use Visiosoft\DemandModule\Demand\DemandModel;
use Visiosoft\DemandModule\Option\Contract\OptionRepositoryInterface;
use Visiosoft\DemandModule\Option\OptionModel;
use Visiosoft\DemandModule\Option\OptionRepository;
use Visiosoft\DemandModule\Service\Contract\ServiceRepositoryInterface;
use Visiosoft\DemandModule\Service\ServiceModel;
use Visiosoft\DemandModule\Service\ServiceRepository;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Visiosoft\DemandModule\Type\TypeModel;
use Visiosoft\DemandModule\Type\TypeRepository;

class DemandModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/demand/steps'           => 'Visiosoft\DemandModule\Http\Controller\Admin\StepsController@index',
        'admin/demand/steps/create'    => 'Visiosoft\DemandModule\Http\Controller\Admin\StepsController@create',
        'admin/demand/steps/edit/{id}' => 'Visiosoft\DemandModule\Http\Controller\Admin\StepsController@edit',
        'admin/demand'           => 'Visiosoft\DemandModule\Http\Controller\Admin\DemandsController@index',
        'admin/demand/create'    => 'Visiosoft\DemandModule\Http\Controller\Admin\DemandsController@create',
        'admin/demand/edit/{id}' => 'Visiosoft\DemandModule\Http\Controller\Admin\DemandsController@edit',
        'admin/demand/show/{id}' => 'Visiosoft\DemandModule\Http\Controller\Admin\DemandsController@show',
        'admin/demand/note/{id}/add' => 'Visiosoft\DemandModule\Http\Controller\Admin\DemandsController@note',

        'admin/demand/services'           => 'Visiosoft\DemandModule\Http\Controller\Admin\ServicesController@index',
        'admin/demand/services/create'    => 'Visiosoft\DemandModule\Http\Controller\Admin\ServicesController@create',
        'admin/demand/services/edit/{id}' => 'Visiosoft\DemandModule\Http\Controller\Admin\ServicesController@edit',

        'admin/demand/services/types/choose' => 'Visiosoft\DemandModule\Http\Controller\Admin\ServicesController@choose',
        'admin/demand/services/types/change/{id}' => 'Visiosoft\DemandModule\Http\Controller\Admin\ServicesController@change',

        'api/get-image' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getImage',
        'api/get-inquiries' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getInquiries',
        'api/get-inquiry-types' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getInquiryTypes',
        'api/get-location' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getLocation',
        'api/get-options' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getOptions',
        'api/submit-demand' => 'Visiosoft\DemandModule\Http\Controller\ApiController@submitDemand',
        'api/get-services-translations' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getServicesTranslations',
        'api/get-default-currencies' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getDefaultCurrencies',
        'api/get-references' => 'Visiosoft\DemandModule\Http\Controller\ApiController@getReferences',
    ];

    protected $bindings = [
        DemandStepsEntryModel::class => StepModel::class,
        DemandDemandsEntryModel::class => DemandModel::class,
        DemandTypesEntryModel::class => TypeModel::class,
        DemandOptionsEntryModel::class => OptionModel::class,
        DemandServicesEntryModel::class => ServiceModel::class,
    ];

    protected $singletons = [
        StepRepositoryInterface::class => StepRepository::class,
        DemandRepositoryInterface::class => DemandRepository::class,
        TypeRepositoryInterface::class => TypeRepository::class,
        OptionRepositoryInterface::class => OptionRepository::class,
        ServiceRepositoryInterface::class => ServiceRepository::class,
    ];

    public function map(FieldRouter $fields, AssignmentRouter $assignments) {
        $fields->route($this->addon, FieldsController::class);
        $assignments->route($this->addon, AssignmentsController::class, 'admin/demand/types');
    }
}
