<?php namespace Visiosoft\DemandModule;

use Anomaly\Streams\Platform\Ui\ControlPanel\ControlPanelBuilder;

class DemandModuleSections
{

    /**
     * Handle the sections.
     *
     * @param ControlPanelBuilder           $builder
     */
    public function handle(ControlPanelBuilder $builder)
    {
        $builder->setSections(
            [
                'demands'  => [
                    'buttons' => [
                        'new_demand'    => [
                            'data-toggle' => 'modal',
                            'data-target' => '#modal',
                            'href'        => 'admin/demand/types/choose',
                        ],
                    ],
                ],
                'services'  => [
                    'buttons' => [
                        'new_service'    => [
                            'data-toggle' => 'modal',
                            'data-target' => '#modal',
                            'href'        => 'admin/demand/services/types/choose',
                        ],
                    ],
                ],
                'types'  => [
                    'buttons'  => [
                        'new_type',
                    ],
                    'sections' => [
                        'assignments' => [
                            'hidden'  => true,
                            'href'    => 'admin/demand/types/assignments/{request.route.parameters.stream}',
                            'buttons' => [
                                'assign_fields' => [
                                    'data-toggle' => 'modal',
                                    'data-target' => '#modal',
                                    'href'        => 'admin/demand/types/assignments/{request.route.parameters.stream}/choose',
                                ],
                            ],
                        ],
                    ],
                ],
                'fields' => [
                    'buttons' => [
                        'new_field' => [
                            'data-toggle' => 'modal',
                            'data-target' => '#modal',
                            'href'        => 'admin/demand/fields/choose',
                        ],
                    ],
                ],
                'options' => [
                    'buttons' => [
                        'new_option'
                    ],
                ],
                'steps' => [
                    'buttons' => [
                        'new_step'
                    ],
                ],
            ]
        );
    }
}
