<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleDemandCreateStepsStream extends Migration
{
    protected $delete = true;

    protected $stream = [
        'slug' => 'steps',
        'title_column' => 'name',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    protected $fields = [
        "name"   => "anomaly.field_type.text",
        "step" => [
            "type"   => "anomaly.field_type.integer",
            "config" => [
                "min" => 1,
            ]
        ]
    ];

    protected $assignments = [
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'step' => [
            'unique' => true,
            'required' => true,
        ],
    ];
}
