<?php namespace Visiosoft\DemandModule\Type\Command;

use Illuminate\Support\Str;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Contracts\Config\Repository;
use Illuminate\Foundation\Bus\DispatchesJobs;

class CreateStream
{

    use DispatchesJobs;

    /**
     * The demand type instance.
     *
     * @var TypeInterface
     */
    protected $type;

    /**
     * Create a new CreateStream instance.
     *
     * @param TypeInterface $type
     */
    public function __construct(TypeInterface $type)
    {
        $this->type = $type;
    }

    /**
     * Handle the command.
     *
     * @param StreamRepositoryInterface $streams
     * @param Repository                $config
     */
    public function handle(StreamRepositoryInterface $streams, Repository $config)
    {
        $streams->create(
            [
                $config->get('app.fallback_locale') => [
                    'name'        => $this->type->getInquiry() . ' ' . $this->type->getInquiryType(),
                    'description' => $this->type->getDescription(),
                ],
                'slug'                              => $this->type->type_slug . '_demand',
                'namespace'                         => 'demand',
                'locked'                            => false,
                'translatable'                      => true,
                'trashable'                         => true,
                'hidden'                            => true,
            ]
        );
    }
}
