<?php namespace Visiosoft\DemandModule\Service\Form;

use Visiosoft\DemandModule\Service\ServiceModel;
use Anomaly\Streams\Platform\Addon\FieldType\FieldType;

class ServiceEntryFormSections
{

    /**
     * Handle the form sections.
     *
     * @param ServiceEntryFormBuilder $builder
     */
    public function handle(ServiceEntryFormBuilder $builder)
    {
        $builder->setSections(
            [
                'fields' => [
                    'fields' => function (ServiceEntryFormBuilder $builder) {
                        return array_map(
                            function (FieldType $field) {
                                return 'entry_' . $field->getField();
                            },
                            array_filter(
                                $builder->getFormFields()->base()->all(),
                                function (FieldType $field) {
                                    return (!$field->getEntry() instanceof ServiceModel);
                                }
                            )
                        );
                    },
                ],
            ]
        );
    }
}
