<?php namespace Visiosoft\DemandModule\Demand;

use Anomaly\Streams\Platform\Entry\Contract\EntryInterface;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Visiosoft\DemandModule\Demand\Contract\DemandInterface;
use Anomaly\Streams\Platform\Model\Demand\DemandDemandsEntryModel;

class DemandModel extends DemandDemandsEntryModel implements DemandInterface
{

    /**
     * Get the demand type.
     *
     * @return null|TypeInterface
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Get the related entry.
     *
     * @return EntryInterface
     */
    public function getEntry()
    {
        return $this->entry;
    }

    /**
     * Get the related entry's ID.
     *
     * @return null|int
     */
    public function getEntryId()
    {
        $entry = $this->getEntry();

        return $entry->getId();
    }
}
