<?php namespace Visiosoft\DemandModule\Service\Form\Command;

use Visiosoft\DemandModule\Entry\Form\EntryFormBuilder;
use Visiosoft\DemandModule\Service\Form\ServiceEntryFormBuilder;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Http\Request;

class AddEntryFormFromRequest
{

    use DispatchesJobs;

    /**
     * The multiple form builder.
     *
     * @var ServiceEntryFormBuilder
     */
    protected $builder;

    /**
     * Create a new AddEntryFormFromRequest instance.
     *
     * @param ServiceEntryFormBuilder $builder
     */
    public function __construct(ServiceEntryFormBuilder $builder)
    {
        $this->builder = $builder;
    }

    /**
     * Handle the command.
     *
     * @param TypeRepositoryInterface $types
     * @param EntryFormBuilder $builder
     * @param Request $request
     */
    public function handle(TypeRepositoryInterface $types, EntryFormBuilder $builder, Request $request)
    {
        /* @var TypeInterface $type */
        $type = $types->find($request->get('type'));

        $this->builder->addForm(
            'entry',
            $builder->setModel($type->getEntryModelName())
        );
    }
}
