<?php namespace Visiosoft\DemandModule\Http\Controller\Admin;

use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Visiosoft\DemandModule\Type\Form\TypeFormBuilder;
use Visiosoft\DemandModule\Type\Table\TypeTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class TypesController extends AdminController
{

    /**
     * Return an index of existing demand types.
     *
     * @param  TypeTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(TypeTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Return the modal to choose a demand type.
     *
     * @param TypeRepositoryInterface $types
     * @return \Illuminate\Contracts\View\View|mixed
     */
    public function choose(TypeRepositoryInterface $types)
    {
        return $this->view->make(
            'module::admin/demand/choose',
            [
                'types' => $types->all(),
            ]
        );
    }

    /**
     * Return the modal to change a demand type.
     *
     * @param TypeRepositoryInterface $types
     * @return \Illuminate\Contracts\View\View|mixed
     */
    public function change(TypeRepositoryInterface $types, $id)
    {
        return $this->view->make(
            'module::admin/demand/change',
            [
                'types' => $types->all(),
                'demand'  => $id,
            ]
        );
    }

    /**
     * Return a form for a new demand type.
     *
     * @param  TypeFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(TypeFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Return a form for editing an existing demand type.
     *
     * @param  TypeFormBuilder $form
     * @param                                             $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(TypeFormBuilder $form, $id)
    {
        return $form->render($id);
    }

}
