<?php namespace Visiosoft\DemandModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Addon\FieldType\FieldTypeCollection;
use Anomaly\Streams\Platform\Assignment\AssignmentModel;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Table\AssignmentTableBuilder;
use Anomaly\Streams\Platform\Field\Form\FieldFormBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\DemandModule\Assignment\AssignmentObserver;
use Visiosoft\DemandModule\Demand\DemandModel;

class FieldsController extends AdminController
{

    /**
     * Return an index of existing fields.
     *
     * @param AssignmentTableBuilder $table
     * @param DemandModel $demandModel
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(AssignmentTableBuilder $table, DemandModel $demandModel)
    {
        AssignmentModel::observe(AssignmentObserver::class);

        return $table
            ->setOption('sortable', true)
            ->setStream($demandModel->getStream())
            ->render();
    }

    /**
     * Choose a field type for creating a field.
     *
     * @param  FieldTypeCollection $fieldTypes
     * @return \Illuminate\View\View
     */
    public function choose(FieldTypeCollection $fieldTypes)
    {
        return $this->view->make('visiosoft.module.demand::admin/fields/choose', ['field_types' => $fieldTypes]);
    }

    /**
     * Return the form for a new field.
     *
     * @param FieldFormBuilder $form
     * @param DemandModel $demandModel
     * @param FieldTypeCollection $fieldTypes
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(FieldFormBuilder $form, DemandModel $demandModel, FieldTypeCollection $fieldTypes)
    {
        $form
            ->setStream($demandModel->getStream())
            ->setOption('auto_assign', true)
            ->setFieldType($fieldTypes->get($this->request->get('field_type')));

        return $form->render();
    }

    /**
     * Return a form to edit the field.
     *
     * @param AssignmentRepositoryInterface $assignments
     * @param FieldFormBuilder $form
     * @param DemandModel $demandModel
     * @param                                             $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(AssignmentRepositoryInterface $assignments, FieldFormBuilder $form, DemandModel $demandModel, $id)
    {
        /* @var AssignmentInterface $assignment */
        $assignment = $assignments->find($id);

        return $form
            ->setStream($demandModel->getStream())
            ->render($assignment->getFieldId());
    }
}
