<?php namespace Visiosoft\DemandModule\Http\Controller\Admin;

use Visiosoft\DemandModule\Demand\Form\DemandFormBuilder;
use Visiosoft\DemandModule\Demand\Table\DemandTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class DemandsController extends AdminController
{

    /**
     * Display an index of existing entries.
     *
     * @param DemandTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(DemandTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param DemandFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(DemandFormBuilder $form)
    {
        $form->setOption('heading', "visiosoft.module.demand::field");

        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param DemandFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(DemandFormBuilder $form, $id)
    {
        $form->setOption('heading', "visiosoft.module.demand::field");

        return $form->render($id);
    }
}
