<?php namespace Visiosoft\DemandModule\Assignment;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentInterface;
use Anomaly\Streams\Platform\Model\EloquentModel;

class AssignmentObserver extends \Anomaly\Streams\Platform\Assignment\AssignmentObserver
{

    /**
     * Fire after the assignment is deleted.
     *
     * @param AssignmentInterface $model
     */
    public function deleted(AssignmentInterface $model)
    {
        /* @var EloquentModel $field */
        if ($field = $model->getField()) {
            $field->delete();
        }

        parent::deleted($model);
    }

}
