new Promise(function (resolve, reject) {
    if (typeof country !== 'undefined') {
        $('select[name="country"]').val(country);
        getCities(parseInt(country));
        if (typeof city !== 'undefined') {
            $('select[name="city"]').val(city);
        }
    } else {
        if (parseInt(default_country)) {
            $('select[name="country"]').val(default_country);
            getCities(parseInt(default_country));
        }
    }
    resolve(true);
}).then(function (resolve) {
    if (resolve) {
        if (typeof city !== 'undefined') {
            $('select[name="city"]').val(city);
            getDistricts(parseInt(city));
            if (typeof district !== 'undefined') {
                $('select[name="district"]').val(district);
            }
        }
        return true;
    }
}).then(function (resolve) {
    if (resolve) {
        if (typeof district !== 'undefined') {
            $('select[name="district"]').val(district);
            getNeighborhoods(parseInt(district));
            if (typeof neighborhood !== 'undefined') {
                $('select[name="neighborhood"]').val(neighborhood);
            }
        }
    }
});
function getCities(country) {
    crud('id=' + country, '/ajax/getCities', 'POST', function (callback) {
        cities = callback;
        $('select[name="city"]').html("<option>" + pick_option + "</option>");
        $.each(cities, function (index, value) {
            $('select[name="city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
    })
}
function getDistricts(city) {
    crud('id=' + city, '/ajax/getDistricts', 'POST', function (callback) {
        cities = callback;
        $('select[name="district"]').html("<option>" + pick_option + "</option>");
        $.each(cities, function (index, value) {
            $('select[name="district"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
    })
}
function getNeighborhoods(district) {
    crud('id=' + district, '/ajax/getNeighborhoods', 'POST', function (callback) {
        cities = callback;
        $('select[name="neighborhood"]').html("<option>" + pick_option + "</option>");
        $.each(cities, function (index, value) {
            $('select[name="neighborhood"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
        });
    })
}
$(document).on('change', 'select[name="country"]', function () {
    getCities($(this).val());
});
$(document).on('change', 'select[name="city"]', function () {
    getDistricts($(this).val())
});
$(document).on('change', 'select[name="district"]', function () {
    getNeighborhoods($(this).val())
});
function crud(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        async: false,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}