<?php namespace Visiosoft\DemandModule\Type;

use Visiosoft\DemandModule\Type\Command\GetStream;
use Visiosoft\DemandModule\Demand\DemandCollection;
use Visiosoft\DemandModule\Type\Contract\TypeInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;
use Anomaly\Streams\Platform\Model\Demand\DemandTypesEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;

class TypeModel extends DemandTypesEntryModel implements TypeInterface
{

    /**
     * Always eager load these.
     *
     * @var array
     */
    protected $with = [
        'translations',
    ];

    /**
     * The cascaded relations.
     *
     * @var array
     */
    protected $cascades = [
        'demands',
    ];

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getInquiry()
    {
        return $this->inquiry;
    }

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getInquiryType()
    {
        return $this->inquiry_type;
    }

    /**
     * Get the slug.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Get the related entry stream.
     *
     * @return StreamInterface
     */
    public function getEntryStream()
    {
        return $this->dispatch(new GetStream($this));
    }

    /**
     * Get the related entry stream ID.
     *
     * @return int
     */
    public function getEntryStreamId()
    {
        if (!$stream = $this->getEntryStream()) {
            return null;
        }

        return $stream->getId();
    }

    /**
     * Get the related entry model.
     *
     * @return EntryModel
     */
    public function getEntryModel()
    {
        $stream = $this->getEntryStream();

        return $stream->getEntryModel();
    }

    /**
     * Get the related entry model name.
     *
     * @return string
     */
    public function getEntryModelName()
    {
        $stream = $this->getEntryStream();

        return $stream->getEntryModelName();
    }

    /**
     * Get the related demands.
     *
     * @return DemandCollection
     */
    public function getDemands()
    {
        return $this->demands;
    }

    /**
     * Return the demands relationship.
     *
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function demands()
    {
        return $this->hasMany('Visiosoft\DemandModule\Demand\DemandModel', 'type_id');
    }
}
