<?php namespace Visiosoft\DemandModule\Http\Controller\Admin;

use Visiosoft\DemandModule\Demand\Contract\DemandInterface;
use Visiosoft\DemandModule\Demand\Contract\DemandRepositoryInterface;
use Visiosoft\DemandModule\Demand\Form\Command\AddEntryFormFromDemand;
use Visiosoft\DemandModule\Demand\Form\Command\AddEntryFormFromRequest;
use Visiosoft\DemandModule\Demand\Form\Command\AddDemandFormFromDemand;
use Visiosoft\DemandModule\Demand\Form\Command\AddDemandFormFromRequest;
use Visiosoft\DemandModule\Demand\Form\DemandEntryFormBuilder;
use Visiosoft\DemandModule\Demand\Table\DemandTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class DemandsController extends AdminController
{

    /**
     * Return a table of existing demands.
     *
     * @param DemandTableBuilder $table
     * @return \Illuminate\Http\Response|\Symfony\Component\HttpFoundation\Response
     */
    public function index(DemandTableBuilder $table) {
        return $table->render();
    }

    /**
     * Return the form for creating a new demand.
     *
     * @param DemandEntryFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(DemandEntryFormBuilder $form)
    {
        $form->setOption('heading', "visiosoft.module.demand::field");

        $this->dispatch(new AddEntryFormFromRequest($form));
        $this->dispatch(new AddDemandFormFromRequest($form));

        return $form->render();
    }

    /**
     * Return the form for editing an existing demand.
     *
     * @param  DemandRepositoryInterface $demands
     * @param  DemandEntryFormBuilder $form
     * @param                                             $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(DemandRepositoryInterface $demands, DemandEntryFormBuilder $form, $id)
    {
        $form->setOption('heading', "visiosoft.module.demand::field");

        /* @var DemandInterface $demand */
        $demand = $demands->find($id);

        $this->dispatch(new AddDemandFormFromDemand($form, $demand)); // First
        $this->dispatch(new AddEntryFormFromDemand($form, $demand)); // Second

        return $form->render($demand);
    }

    /**
     * Delete a demand and go back.
     *
     * @param  DemandRepositoryInterface $demands
     * @param                                    $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function delete(DemandRepositoryInterface $demands, $id)
    {
        $demands->delete($demand = $demands->find($id));

        $demand->entry->delete();

        return redirect()->back();
    }
}
