<?php namespace Visiosoft\DemandModule\Option;

use Anomaly\Streams\Platform\Model\Repeater\RepeaterOptionsRepeaterEntryModel;
use Illuminate\Support\Facades\DB;
use Visiosoft\DemandModule\Option\Contract\OptionRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class OptionRepository extends EntryRepository implements OptionRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OptionModel
     */
    protected $model;
    /**
     * @var RepeaterOptionsRepeaterEntryModel
     */
    private $optionsRepeaterEntryModel;

    /**
     * Create a new OptionRepository instance.
     *
     * @param OptionModel $model
     */
    public function __construct(OptionModel $model, RepeaterOptionsRepeaterEntryModel $optionsRepeaterEntryModel)
    {
        $this->model = $model;
        $this->optionsRepeaterEntryModel = $optionsRepeaterEntryModel;
    }

    public function getOptionsByInquiryTypeId($inquiryTypeId) {
        $relatedOptions = DB::table('demand_options_related_type')
            ->where('related_id', $inquiryTypeId)->get();

        if (count($relatedOptions)) {
            $optionNames = $this->newQuery()
                ->whereIn('demand_options.id', array_column($relatedOptions->toArray(), 'entry_id'))
                ->get();

            $totalOptions = array();
            foreach ($optionNames as $optionName) {
                $relatedOptions = DB::table('demand_options_options')->select('related_id')
                    ->where('entry_id', $optionName->id)->get();
                $relatedOptions = array_column($relatedOptions->toArray(), 'related_id');

                $options = $this->optionsRepeaterEntryModel->newQuery()->whereIn('id', $relatedOptions)->get();
                foreach ($options as $option) {
                    $option->setAttribute('option_photo_url', $option->option_photo->url());
                }

                $totalOptions[$optionName->step] = [
                    'title' => $optionName->title,
                    'slug' => $optionName->options_slug,
                    'options' => $options,
                ];
            }

            return $totalOptions;
        }

        return 0;
    }
}
