<?php namespace Visiosoft\DemandModule\Http\Controller\Admin;

use Visiosoft\DemandModule\Type\Contract\TypeRepositoryInterface;
use Visiosoft\DemandModule\Service\Contract\ServiceInterface;
use Visiosoft\DemandModule\Service\Contract\ServiceRepositoryInterface;
use Visiosoft\DemandModule\Service\Form\Command\AddEntryFormFromService;
use Visiosoft\DemandModule\Service\Form\Command\AddEntryFormFromRequest;
use Visiosoft\DemandModule\Service\Form\Command\AddServiceFormFromService;
use Visiosoft\DemandModule\Service\Form\Command\AddServiceFormFromRequest;
use Visiosoft\DemandModule\Service\Form\ServiceEntryFormBuilder;
use Visiosoft\DemandModule\Service\Table\ServiceTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ServicesController extends AdminController
{

    /**
     * Return a table of existing services.
     *
     * @param ServiceTableBuilder $table
     * @return \Illuminate\Http\Response|\Symfony\Component\HttpFoundation\Response
     */
    public function index(ServiceTableBuilder $table) {
        return $table->render();
    }

    /**
     * Return the modal for choosing a service type.
     *
     * @param  TypeRepositoryInterface $types
     * @return \Illuminate\View\View
     */
    public function choose(TypeRepositoryInterface $types)
    {
        return $this->view->make('module::admin/service/choose', ['types' => $types->all()]);
    }

    /**
     * Return the modal for changing a service type.
     *
     * @param  TypeRepositoryInterface $types
     * @param $id
     * @return \Illuminate\View\View
     */
    public function change(TypeRepositoryInterface $types, $id)
    {
        return $this->view->make('module::admin/services/change', ['types' => $types->all(), 'service' => $id]);
    }

    /**
     * Return the form for creating a new service.
     *
     * @param ServiceEntryFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ServiceEntryFormBuilder $form)
    {
        $this->dispatch(new AddEntryFormFromRequest($form));
        $this->dispatch(new AddServiceFormFromRequest($form));

        return $form->render();
    }

    /**
     * Return the form for editing an existing service.
     *
     * @param  ServiceRepositoryInterface $services
     * @param  ServiceEntryFormBuilder $form
     * @param                                             $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ServiceRepositoryInterface $services, ServiceEntryFormBuilder $form, $id)
    {
        $form->setOption('heading', "visiosoft.module.demand::field");

        /* @var ServiceInterface $service */
        $service = $services->find($id);

        $this->dispatch(new AddServiceFormFromService($form, $service)); // First
        $this->dispatch(new AddEntryFormFromService($form, $service)); // Second

        return $form->render($service);
    }

    /**
     * Delete a service and go back.
     *
     * @param  ServiceRepositoryInterface $services
     * @param                                    $id
     * @return \Illuminate\Http\RedirectResponse
     */
    public function delete(ServiceRepositoryInterface $services, $id)
    {
        $services->delete($service = $services->find($id));

        $service->entry->delete();

        return redirect()->back();
    }
}
