<?php namespace Visiosoft\DataVonhomExtension\Seed;

use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use ZipArchive;


class VonhomDataSeeder extends Seeder
{
    public function run()
    {

        $app = app(Application::class)->getReference() . "_";
        $demo = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/data/vonhom.sql'));
        Model::unguard();
        DB::unprepared($demo);
        Model::reguard();
        $zip = new \ZipArchive();
        $zip->open(realpath(dirname(__DIR__)) . '/data/vonhom-img.zip', \ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/' . app(Application::class)->getReference() . '/files-module/local/'));
        $zip->close();

    }

}
