<?php

namespace Visiosoft\DataVehicledemoExtension;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterHomepageBannerEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterPopularCategoriesEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterShowcaseEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterTinySliderEntryModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Faker\Factory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Input\ArgvInput;
use ZipArchive;

class DataVehicledemoExtensionSeeder extends Seeder
{
    private $settingRepository;
    private $userRepository;
    public function __construct(
        SettingRepositoryInterface $settingRepository,
        UserRepositoryInterface $userRepository
    )
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
        $this->userRepository = $userRepository;
    }

    public function run()
    {

        $faker = Factory::create();

        for ($i=0; $i < 10; $i++) {
            $id = 77770 + $i;
            if (!$this->userRepository->findBy("id",$id)){
                $user = [
                    'id' => $id,
                    'username' => $faker->userName,
                    'first_name' => $faker->firstName,
                    'last_name' => $faker->lastName,
                    'display_name' => $faker->name,
                    'email' => $faker->safeEmail,
                    'password' => '$2y$10$BjczsLA8HC1k6emTIG0ZLertUAvaxo4Z855bTN8u88rRYTomrUPfe',
                    'activated' => 1,
                    'enabled' => 1,
                    'gsm_phone' => $faker->e164PhoneNumber,
                    'land_phone' => $faker->e164PhoneNumber,
                    'office_phone' => $faker->e164PhoneNumber,
                ];
                $this->userRepository->create($user);
            }
        }


        $application_reference = (new ArgvInput())->getParameterOption('--app', env('APPLICATION_REFERENCE', 'default'));
        $categories = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/categories.sql'));
        $categoriesTrans = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/categoryTranslations.sql'));
        $advs = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/advs.sql'));
        $files = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/files.sql'));

        Model::unguard();
        DB::unprepared($advs);
        DB::unprepared($categories);
        DB::unprepared($files);
        DB::unprepared($categoriesTrans);

        $sahibinden = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/themeSeeders/sahibinden.sql'));

        if ($this->settingRepository->get('streams::standard_theme') && $this->settingRepository->get('streams::standard_theme')['value'] == 'visiosoft.theme.sahibinden'){
            $this->settingRepository->set('visiosoft.theme.sahibinden::logo_web',999500170);
            $this->settingRepository->set('visiosoft.theme.sahibinden::logo_mobile',999500170);
            $this->settingRepository->set('visiosoft.module.advs::latest-limit', 20);
            $this->settingRepository->set('visiosoft.theme.sahibinden::header_primary_color', '#90a7af');
            $this->settingRepository->set('visiosoft.theme.sahibinden::search_banner_web', 100007780);


            $zip = new \ZipArchive();
            $zip->open(realpath(dirname(__DIR__)) . '/src/themeSeeders/banner.zip', ZipArchive::CREATE);
            $zip->extractTo(storage_path('streams/' . $application_reference . '/files-module/local/images/'));
            $zip->close();

            DB::unprepared($sahibinden);
//            todo add banner image
        }

        if (is_module_installed('visiosoft.module.customfields')){
            $customfields = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/customfields.sql'));
            DB::unprepared($customfields);
        }
        if (is_module_installed('visiosoft.module.store')) {
            $store = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/store.sql'));
            DB::unprepared($store);
        }
        if (is_module_installed('visiosoft.module.dopings')) {
            $dopings = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/dopings.sql'));
            DB::unprepared($dopings);
        }


        Model::reguard();
        $zip = new \ZipArchive();
        $zip->open(realpath(dirname(__DIR__)) . '/src/seed/data/advs.zip', ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/' . $application_reference . '/files-module/local/images/'));
        $zip->open(realpath(dirname(__DIR__)) . '/src/seed/data/store.zip', ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/' . $application_reference . '/files-module/local/images/'));

        $zip->close();
        //Sync Files
        $this->command->call('files:sync');
        Artisan::call('refresh');
        Artisan::call('assets:clear');
    }
}