<?php

namespace Visiosoft\DataShoppingExtension;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Input\ArgvInput;
use ZipArchive;

class DataShoppingExtensionSeeder extends Seeder
{

    private $settingRepository;
    private $userRepository;

    public function __construct(
        SettingRepositoryInterface $settingRepository,
        UserRepositoryInterface    $userRepository
    )
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
        $this->userRepository = $userRepository;
    }

    public function run()
    {
        $app = app(Application::class)->getReference();
        $application_reference = (new ArgvInput())->getParameterOption('--app', env('APPLICATION_REFERENCE', 'default'));
        $advs = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/advs.sql'));
        $categories = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/categories.sql'));
        $files = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/files.sql'));

        $footer = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/footer.sql'));

        Model::unguard();
        DB::unprepared($advs);
        DB::unprepared($categories);
        DB::unprepared($files);

        DB::unprepared($footer);

        $zip = new \ZipArchive();

        if ($this->settingRepository->get('streams::standard_theme') && $this->settingRepository->get('streams::standard_theme')['value'] == 'visiosoft.theme.gg') {
            $ggtheme = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/themeSeeders/ggtheme.sql'));
            DB::unprepared($ggtheme);

            $this->settingRepository->set('visiosoft.theme.gg::horizontal_menu_categories', 'a:10:{i:0;s:6:"240128";i:1;s:6:"240129";i:2;s:6:"240133";i:3;s:6:"240232";i:4;s:6:"240240";i:5;s:6:"240241";i:6;s:6:"240415";i:7;s:6:"240443";i:8;s:6:"240471";i:9;s:6:"240130";}');
            $this->settingRepository->set('visiosoft.theme.gg::choices_tabs_categories', 'a:6:{i:0;s:6:"240128";i:1;s:6:"240129";i:2;s:6:"240133";i:3;s:6:"240415";i:4;s:6:"240471";i:5;s:6:"240130";}');
            $this->settingRepository->set('visiosoft.theme.gg::betsellers', 'a:9:{i:0;s:1:"6";i:1;s:5:"50112";i:2;s:5:"50111";i:3;s:5:"50060";i:4;s:5:"50076";i:5;s:5:"50091";i:6;s:5:"50092";i:7;s:5:"50096";i:8;s:4:"1077";}');
            $this->settingRepository->set('visiosoft.theme.gg::first_banner', '<p><img style="width:100%; border-radius:8px;" alt="Bannerr" src="/files/images/gidiyor8.png"></p>');
            $this->settingRepository->set('visiosoft.theme.gg::second_banner', '<p><img style="width:100%; border-radius:8px;" alt="Bannerr" src="/files/images/gidiyor4.png"></p>');
            $this->settingRepository->set('visiosoft.module.style_selector::detail', 'visiosoft.extension.gg_style_provider');


            if (is_module_installed('visiosoft.module.stories')) {
                $story = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/themeSeeders/story.sql'));
                DB::unprepared($story);
            }
        }

        Model::reguard();

        $zip->open(realpath(dirname(__DIR__)) . '/src/seed/data/shopping.zip', ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/' . $app . '/files-module/local/images/'));

        $zip->close();
//        Sync Files
        $this->command->call('files:sync');
        Artisan::call('assets:clear');
        $this->command->call('refresh');
    }
}