<?php

namespace Visiosoft\DataGidiyorExtension;

use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\DopingsModule\Type\Contract\TypeRepositoryInterface;
use ZipArchive;

class DataGidiyorExtensionSeeder extends Seeder
{


    public function run()
    {
        $app = app(Application::class)->getReference()."_";

        $demo = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/gidiyor_demodata.sql'));
        Model::unguard();
        DB::unprepared($demo);
        Model::reguard();

        $zip = new ZipArchive();
        $zip->open(realpath(dirname(__DIR__)) . '/src/seed/data/images.zip', ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/'.app(Application::class)->getReference().'/files-module/local/'));
        $zip->close();

        if (app(AdvModel::class)->is_enabled('dopings')) {
            $typeRepository = app(TypeRepositoryInterface::class);
            if (!$typeRepository->findBySlug('super_price')) {
                $typeRepository->create([
                    'en' => [
                        'name' => 'Super Price',
                        'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'

                    ],
                    'tr' => [
                        'name' => 'Süper Fiyat',
                        'description' => 'İlanınız her gün binlerce kişinin ziyaret ettiği sitemizde ana sayfada yer alsın istiyorsanız hemen alın'
                    ],
                    'slug' => 'super_price',
                    'price' => 100,
                    'duration' => 15,
                    'icon' => 'money'
                ]);
            }
        }

        Artisan::call('files:sync');
        Artisan::call('assets:clear');
    }
}