<?php

namespace Visiosoft\DataExpertExtension;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\VariablesModule\Variable\Contract\VariableRepositoryInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Anomaly\NavigationModule\Menu\MenuRepository;
use Anomaly\NavigationModule\Link\LinkModel;
use Anomaly\UrlLinkTypeExtension\UrlLinkTypeModel;
use Illuminate\Support\Facades\DB;

class DataExpertExtensionSeeder extends Seeder
{
    private $settingRepository;
    private $streamRepository;
    private $fieldRepository;
    private $assignmentRepository;
    private $variableRepository;

    public function __construct(SettingRepositoryInterface $settingRepository,
                                StreamRepositoryInterface $streamRepository,
                                FieldRepositoryInterface $fieldRepository,
                                AssignmentRepositoryInterface $assignmentRepository,
                                VariableRepositoryInterface $variableRepository)
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
        $this->streamRepository = $streamRepository;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->variableRepository = $variableRepository;
    }

    public function run()
    {
        $app = app(Application::class)->getReference()."_";
        // Activate
        $this->settingRepository->set('streams::standard_theme', 'visiosoft.theme.sahibinden');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_bottom', '<p><img alt="Banner2" src="/files/images/banner2.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_top_latestAds', '<p><img alt="Banner1" src="/files/images/banner1.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_bottom_latestAds', '<p><img alt="Banner3" src="/files/images/banner3.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::home_bottom_left_categories', '<p><img alt="Group 41701" src="/files/images/Group_41701.png"></p>');
        $this->settingRepository->set('visiosoft.theme.sahibinden::banner_web', '1295');

        $menus = [[
            'en' => [
                'name' => 'Customer Service'
            ],
            'slug' => 'customer_service',
        ], [
            'en' => [
                'name' => 'About Us',
            ],
            'slug' => 'about_us',
        ], [
            'en' => [
                'name' => 'Buy And Sell',
            ],
            'slug' => 'buy_and_sell',
        ]];

        $menuRepository = app(MenuRepository::class);
        foreach ($menus as $menu) {
            if (!$menuRepository->findBySlug($menu['slug'])) {
                $menuRepository->create($menu);
            }
        }

        $links = [[
            'entry' => [
                'en' => [
                    'title' => 'OpenClassify.com',
                ],
                'url' => 'https://openclassify.com/',
            ],
            'menu' => 'customer_service'
        ], [
            'entry' => [
                'en' => [
                    'title' => 'Ocify.co',
                ],
                'url' => 'https://ocify.co/',
            ],
            'menu' => 'about_us'
        ], [
            'entry' => [
                'en' => [
                    'title' => 'Visiosoft Inc.',
                ],
                'url' => 'https://visiosoft.com.tr/',
            ],
            'menu' => 'buy_and_sell'
        ]];

        $linkModel = new LinkModel();
        foreach ($links as $link) {
            $menu = $menuRepository->findBySlug($link['menu']);
            $url = new UrlLinkTypeModel();

            $entry = $url->newQuery()->create($link['entry']);

            $linkModel->newQuery()->create([
                'menu' => $menu,
                'target' => '_blank',
                'entry' => $entry,
                'type' => 'anomaly.extension.url_link_type',
            ]);
        }
        // Seeder
        // Seeder
        $app = app(Application::class)->getReference()."_";
        $demo = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/expert_demodata.sql'));
        Model::unguard();
        DB::unprepared($demo);
        Model::reguard();
        $zip = new \ZipArchive();
        $zip->open(realpath(dirname(__DIR__)) . '/src/seed/data/local.zip', \ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/' . app(Application::class)->getReference() . '/files-module'));
        $zip->close();
        // Variables Seed
        if (!$stream = $this->streamRepository->findBySlugAndNamespace('sahibinden_theme', 'variables')) {
            $stream = $this->streamRepository->newQuery()
                ->create([
                    'name' => 'sahibinden-theme',
                    'namespace' => 'variables',
                    'slug' => 'sahibinden_theme',
                    'prefix' => 'variables_',
                    'translatable' => true,
                ]);
        }

        if (!$field = $this->fieldRepository->findBySlugAndNamespace('sahibinden_footer_text', 'variables')) {
            $field = $this->fieldRepository->newQuery()
                ->create([
                    'name' => 'sahibinden footer text',
                    'namespace' => 'variables',
                    'slug' => 'sahibinden_footer_text',
                    'type' => 'anomaly.field_type.textarea',
                    'config' => 'a:6:{s:4:"rows";s:1:"6";s:3:"min";N;s:3:"max";N;s:12:"show_counter";b:0;s:8:"autogrow";b:1;s:13:"default_value";s:330:"The ad creator is solely responsible for the content, correctness, accuracy and legal obligation of all posted ads, entries, ideas and information. openclassify.com is not in any way responsible for the quality or legality of content created and posted by its users. You should contact the ad creator directly with your questions.";}',
                    'locked' => false,
                ]);
        }

        if (!$this->assignmentRepository->findByStreamAndField($stream, $field)) {
            $this->assignmentRepository->newQuery()
                ->create([
                    'stream_id' => $stream->id,
                    'field_id' => $field->id,
                    'translatable' => true,
                ]);
        }

        Artisan::call('files:sync');
        Artisan::call('assets:clear');
    }
}