<?php

namespace Visiosoft\DataEmlakExtension;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Faker\Factory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Symfony\Component\Console\Input\ArgvInput;
use ZipArchive;

class DataEmlakExtensionSeeder extends Seeder
{

    private $settingRepository;
    private $userRepository;
    public function __construct(
        SettingRepositoryInterface $settingRepository,
        UserRepositoryInterface $userRepository
    )
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
        $this->userRepository = $userRepository;
    }
    public function run()
    {
        $faker = Factory::create();

        for ($i=0; $i < 10; $i++) {
            $id = 77770 + $i;
            if (!$this->userRepository->findBy("id",$id)){
                $user = [
                    'id' => $id,
                    'username' => $faker->userName,
                    'first_name' => $faker->firstName,
                    'last_name' => $faker->lastName,
                    'display_name' => $faker->name,
                    'email' => $faker->safeEmail,
                    'password' => '$2y$10$BjczsLA8HC1k6emTIG0ZLertUAvaxo4Z855bTN8u88rRYTomrUPfe',
                    'activated' => 1,
                    'enabled' => 1,
                    'gsm_phone' => $faker->e164PhoneNumber,
                    'land_phone' => $faker->e164PhoneNumber,
                    'office_phone' => $faker->e164PhoneNumber,
                ];
                $this->userRepository->create($user);
            }
        }

        $app = app(Application::class)->getReference();
        $application_reference = (new ArgvInput())->getParameterOption('--app', env('APPLICATION_REFERENCE', 'default'));
        $advs = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/advs.sql'));
        $categories = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/categories.sql'));
        $files = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/files.sql'));

        Model::unguard();
        DB::unprepared($advs);
        DB::unprepared($categories);
        DB::unprepared($files);

        $zip = new \ZipArchive();

        if (is_module_installed('visiosoft.module.customfields')){
            $customfields = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/customfields.sql'));
            $cfvalue = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/cfvalue.sql'));
            $cfvalueTranslations = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/cfvalueTranslations.sql'));
            DB::unprepared($customfields);
            DB::unprepared($cfvalue);
            DB::unprepared($cfvalueTranslations);
        }
        if (is_module_installed('visiosoft.module.store')) {
            $store = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/store.sql'));
            DB::unprepared($store);
            $zip->open(realpath(dirname(__DIR__)) . '/src/seed/data/store.zip', ZipArchive::CREATE);
            $zip->extractTo(storage_path('streams/' . $app . '/files-module/local/images/'));
        }
        if (is_module_installed('visiosoft.module.dopings')) {
            $dopings = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/dopings.sql'));
            DB::unprepared($dopings);
        }


        if ($this->settingRepository->get('streams::standard_theme') && $this->settingRepository->get('streams::standard_theme')['value'] == 'visiosoft.theme.sahibinden'){
            $this->settingRepository->set('visiosoft.theme.sahibinden::logo_web',939393939);
            $this->settingRepository->set('visiosoft.theme.sahibinden::logo_mobile',939393939);
            $this->settingRepository->set('visiosoft.module.advs::latest-limit', 20);
            $this->settingRepository->set('visiosoft.theme.sahibinden::header_primary_color', '#90a7af');
            $this->settingRepository->set('visiosoft.theme.sahibinden::search_banner_web', 999998231);

            $zip->open(realpath(dirname(__DIR__)) . '/src/themeSeeders/sahibinden.zip', ZipArchive::CREATE);
            $zip->extractTo(storage_path('streams/' . $application_reference . '/files-module/local/images/'));

            $sahibinden = str_replace('{application_reference}', $application_reference, file_get_contents(realpath(dirname(__DIR__)) . '/src/themeSeeders/sahibinden.sql'));
            DB::unprepared($sahibinden);
//            todo add banner image
        }

        if ($this->settingRepository->get('streams::standard_theme') && $this->settingRepository->get('streams::standard_theme')['value'] == 'visiosoft.theme.restate'){
            $this->settingRepository->set('visiosoft.theme.restate::header_category1', 16623);
            $this->settingRepository->set('visiosoft.theme.restate::header_category2', 16622);
            $this->settingRepository->set('visiosoft.theme.restate::search_cat1', 16623);
            $this->settingRepository->set('visiosoft.theme.restate::search_cat2', 16622);
            $this->settingRepository->set('visiosoft.theme.restate::search_cat3', 247519);
            $this->settingRepository->set('visiosoft.theme.restate::search_cat4', 89789);

            $this->settingRepository->set('visiosoft.module.advs::translatable_slug', true);
        }

        Model::reguard();

        $zip->open(realpath(dirname(__DIR__)) . '/src/seed/data/estate-images.zip', ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/' . $app . '/files-module/local/images/'));

        $zip->close();
        //Sync Files
        $this->command->call('files:sync');
        Artisan::call('assets:clear');
    }
}