<?php

namespace Visiosoft\DataEmlakExtension;

use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use ZipArchive;

class DataEmlakExtensionSeeder extends Seeder
{


    public function run()
    {
        $app = app(Application::class)->getReference()."_";

        $demo = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/emlak_demodata.sql'));
        $advs = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/advs.sql'));
        Model::unguard();
        DB::unprepared($advs);
        DB::unprepared($demo);
        Model::reguard();

        $zip = new \ZipArchive();
        $zip->open(realpath(dirname(__DIR__)) . '/src/seed/data/estate-images.zip', ZipArchive::CREATE);
        $zip->extractTo(storage_path('streams/' . $app . '/files-module/local/images/'));
        $zip->close();
        //Sync Files
        $this->command->call('files:sync');
        Artisan::call('assets:clear');
    }
}