<?php

namespace Visiosoft\DataEmlakExtension;

use Anomaly\Streams\Platform\Application\Application;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class DataEmlakExtensionSeeder extends Seeder
{


    public function run()
    {
        $app = app(Application::class)->getReference()."_";

        $demo = str_replace('{application_reference}', $app, file_get_contents(realpath(dirname(__DIR__)) . '/src/seed/data/emlak_demodata.sql'));
        Model::unguard();
        DB::unprepared($demo);
        Model::reguard();

        Artisan::call('assets:clear');
    }
}