<?php namespace Visiosoft\DataAlfa1Extension\Commands;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\FilesModule\File\FileSynchronizer;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use League\Flysystem\MountManager;

class FilesSync
{
    public function handle(
        MountManager $manager,
        FileSynchronizer $synchronizer,
        FolderRepositoryInterface $folders,
        FileRepositoryInterface $files
    ) {
        foreach ($folders->all() as $folder) {

            $contents = array_filter(
                $manager->listContents($folder->path()),
                function (array $file) {
                    return $file['type'] == 'file';
                }
            );

            foreach ($contents as $file) {
                if (!$files->findByNameAndFolder($file['basename'], $folder)) {

                    $resource = $manager->get($path = $folder->path($file['basename']));

                    $synchronizer->sync($resource, $folder->getDisk());
                }
            }
        }
    }
}
