<?php namespace Visiosoft\CwpModule\Task;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TaskRepository extends EntryRepository implements TaskRepositoryInterface
{

    protected $model;
    private $key;
    private $url;

    public function __construct(TaskModel $model)
    {
        $this->model = $model;
        $this->key = setting_value('visiosoft.module.cwp::APIkey');
        $this->url = setting_value('visiosoft.module.cwp::APIurl');
    }

    public function newRequest($function, $params = [], $key = null)
    {
        $params = array_merge($params, [
            'key' => (!is_null($key)) ? $key : $this->key
        ]);
        $newTask = $this->createRequest($function, $params);

        $url = $this->url . $function;
//        dd($url,$params);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($ch, CURLOPT_POST, 1);
        $response = curl_exec($ch);
        curl_close($ch);

        $newTask->update(['response' => json_encode($response),]);

        return $newTask;
    }

    public function createRequest($function, $request)
    {
        return $this->create([
            'function' => $function,
            'request' => json_encode($request),
        ]);
    }

    public function newSiteAndDatabase($domain, $username, $email)
    {
        //Create Account
        $return_params = [
            'username' => $username,
            'email' => $email,
            'domain' => $domain,
            'pass' => str_random(8),
            'database' => $username . "_" . substr($username, 0, 3),
        ];
        $account_params = [
            'action' => 'add',
            'domain' => $domain,
            'user' => $username,
            'pass' => $return_params['pass'],
            'email' => $email,
            'package' => 'default',
            'lang' => 'en',
            'inode' => '0',
            'limit_nproc' => '40',
            'limit_nofile' => '150',
            'server_ips' => '3.14.124.200',
        ];
        $return_params['log_account_id'] = $this->newRequest('account', $account_params)->getId();

        //Create Database
        $database_params = [
            'action' => 'add',
            'user' => $username,
            'database' => substr($username, 0, 3),
        ];
        $return_params['log_database_id'] = $this->newRequest('databasemysql', $database_params)->getId();

        //SSL Add
        $ssl_params = [
            'action' => 'add',
            'name' => $domain,
            'user' => $username,
        ];
        $return_params['log_ssl_id'] = $this->newRequest('autossl', $ssl_params)->getId();

        return $return_params;
    }

}
