<?php namespace Visiosoft\CwpModule\Task;

use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TaskRepository extends EntryRepository implements TaskRepositoryInterface
{

    protected $model;
    private $key;
    private $url;

    public function __construct(TaskModel $model)
    {
        $this->model = $model;
        $this->key = setting_value('visiosoft.module.cwp::APIkey');
        $this->url = setting_value('visiosoft.module.cwp::APIurl');
    }

    public function newRequest($function, $params = [], $key = null)
    {
        $params = array_merge($params, [
            'key' => (!is_null($key)) ? $key : $this->key
        ]);
        $newTask = $this->createRequest($function, $params);

        $url = $this->url . $function;
//        dd($url,$params);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($ch, CURLOPT_POST, 1);

        try {
            $response = curl_exec($ch);
        } catch (\Exception $exception)
        {
            throw new \Exception("Doğru cevap dönmedi");
        }
        $response = curl_exec($ch);
        curl_close($ch);

        $newTask->update([
            'response' => $response,
            'status' => (json_decode($response, true)['status'] == "OK") ? true : false,
        ]);

        return $newTask;
    }

    public function createRequest($function, $request)
    {
        return $this->create([
            'function' => $function,
            'request' => json_encode($request),
        ]);
    }

    public function newSiteAndDatabase($domain, $username, $email, $type)
    {
        //Create Account
        $return_params = [
            'username' => $domain,
            'email' => $email,
            'domain' => $domain . "." . $type,
            'pass' => str_random(8),
            'database' => $domain . "_" . substr($domain, 0, 3),
            'account_status' => false,
            'database_status' => false,
            'ssl_status' => false,
            'message' => "",
        ];

        $account_params = [
            'action' => 'add',
            'domain' => $return_params['domain'],
            'user' => $return_params['username'],
            'pass' => $return_params['pass'],
            'email' => $email,
            'package' => 'default',
            'lang' => 'en',
            'inode' => '0',
            'limit_nproc' => '40',
            'limit_nofile' => '150',
            'server_ips' => '3.14.124.200',
        ];
        $account = $this->newRequest('account', $account_params);
        $return_params['log_account_id'] = $account->getId();
        $return_params['account_status'] = $account->status;
        $return_params['message'] .=
            ($account->status) ? '' : json_decode($account->response, true)['msj'];

        if ($account->status) {
            //Create Database
            $database_params = [
                'action' => 'add',
                'user' => $return_params['username'],
                'database' => substr($return_params['username'], 0, 3),
            ];
            $database = $this->newRequest('databasemysql', $database_params);
            $return_params['log_database_id'] = $database->getId();
            $return_params['database_status'] = $database->status;
            $return_params['message'] .=
                ($database->status) ? '' : json_decode($database->response, true)['msj'];

//
//            //SSL Add
//            $ssl_params = [
//                'action' => 'add',
//                'name' => $domain,
//                'user' => $username,
//            ];
//            $ssl = $this->newRequest('autossl', $ssl_params);
//            $return_params['log_ssl_id'] = $ssl->getId();
//            $return_params['ssl_status'] = $ssl->status;
//            $return_params['message'] .=
//                ($ssl->status) ? '' : json_decode($ssl->response, true)['msj'];

        }
        return $return_params;
    }

}
