<?php namespace Visiosoft\CwpModule\Task;

use Visiosoft\CwpModule\Server\Contract\ServerRepositoryInterface;
use Visiosoft\CwpModule\Task\Contract\TaskRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class TaskRepository extends EntryRepository implements TaskRepositoryInterface
{

    protected $model;

    public function __construct(TaskModel $model)
    {
        $this->model = $model;
    }

    public function newRequest($function, $key, $url_or_node, $params = [])
    {
        if(is_null($key))
        {
            $server_repo = app(ServerRepositoryInterface::class);

            if (!$node = $server_repo->findBy('node_name', $url_or_node)) {
                $return_params['msj'] = trans('visiosoft.module.cwp::message.server_not_found');
                return $return_params;
            }
            $url_or_node = $node->getApiUrl();
            $key = $node->getApiKey();
        }

        $params = array_merge($params, ['key' => $key]);
        $newTask = $this->createRequest($function, $params);

        $url = $url_or_node . $function;
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($params));
        curl_setopt($ch, CURLOPT_POST, 1);

        try {
            $response = curl_exec($ch);
        } catch (\Exception $exception) {
            $exception->getMessage();
        }
        curl_close($ch);

        if ($response) {
            $response = $this->getResponseJson($response);
            $newTask->update([
                'response' => $response,
                'status' => ($response !== "" && json_decode($response, true)['status'] == "OK") ? true : false,
            ]);
        }
        return $newTask;
    }

    public function createRequest($function, $request)
    {
        return $this->create([
            'function' => $function,
            'request' => json_encode($request),
        ]);
    }

    public function newSiteAndDatabase($node_name, $domain, $username, $email, $type)
    {
        $server_repo = app(ServerRepositoryInterface::class);

        if (!$node = $server_repo->findBy('node_name', $node_name)) {
            $return_params['message'] = trans('visiosoft.module.cwp::message.server_not_found');
            return $return_params;
        }

        //Create Account
        $return_params = [
            'username' => $domain,
            'email' => $email,
            'domain' => $domain . "." . $type,
            'pass' => str_random(8),
            'database' => $domain . "_" . substr($domain, 0, 3),
            'account_status' => false,
            'database_status' => false,
            'ssl_status' => false,
            'message' => "",
        ];

        if (strlen($domain) > 8) {
            $return_params['message'] = trans('module::message.username_max_characters_msg');
            return $return_params;
        }

        $account_params = [
            'action' => 'add',
            'domain' => $return_params['domain'],
            'user' => $return_params['username'],
            'pass' => $return_params['pass'],
            'email' => $email,
            'package' => 'default',
            'backup' => '0',
            'lang' => 'en',
            'inode' => '0',
            'limit_nproc' => '40',
            'limit_nofile' => '150',
            'server_ips' => $node->server_ip,
        ];
        $account = $this->newRequest('account', $node->getApiKey(), $node->getApiUrl(), $account_params);


        //Close Backup
        $close_backup_params = [
            'action' => 'udp',
            'user' => $return_params['username'],
            'email' => $email,
            'package' => 'default',
            'backup' => 'off',
            'inode' => '0',
            'limit_nproc' => '40',
            'limit_nofile' => '150',
            'server_ips' => $node->server_ip,
        ];

        $close_backup_params = $this->newRequest('account', $node->getApiKey(), $node->getApiUrl(), $close_backup_params);

        $return_params['log_account_id'] = $account->getId();
        $return_params['account_status'] = $account->status;
        $return_params['message'] .=
            ($account->status) ? '' : json_decode($account->response, true)['msj'];

        if ($account->status) {
            //Create Database
            $database_params = [
                'action' => 'add',
                'user' => $return_params['username'],
                'database' => substr($return_params['username'], 0, 3),
            ];
            $database = $this->newRequest('databasemysql', $node->getApiKey(), $node->getApiUrl(), $database_params);
            $return_params['log_database_id'] = $database->getId();
            $return_params['database_status'] = $database->status;
            $return_params['message'] .=
                ($database->status) ? '' : json_decode($database->response, true)['msj'];

//
//            //SSL Add
//            $ssl_params = [
//                'action' => 'add',
//                'name' => $domain,
//                'user' => $username,
//            ];
//            $ssl = $this->newRequest('autossl', $ssl_params);
//            $return_params['log_ssl_id'] = $ssl->getId();
//            $return_params['ssl_status'] = $ssl->status;
//            $return_params['message'] .=
//                ($ssl->status) ? '' : json_decode($ssl->response, true)['msj'];

        }
        return $return_params;
    }

    public function getResponseJson($response)
    {
        if ($response) {
            $pattern = '/"(status)":("(\\"|[^"])*"|\[("(\\"|[^"])*"(,"(\\"|[^"])*")*)?\])/';
            return (preg_match($pattern, $response, $match)) ? "{" . $match[0] . "}" : '';
        } else {
            return json_encode([
                'status' => 'error',
                'message' => trans('module::message.no_answer_returned')
            ]);
        }
    }

}
