<?php namespace Visiosoft\CustomfieldsModule\CustomField\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\CustomfieldsModule\Parent\ParentModel;

class CustomFieldTableBuilder extends TableBuilder
{
    /**
     * @param CustomFieldTableBuilder $builder
     * @param ParentModel $parentModel
     * @param Builder $query
     */
    public function onQuerying(CustomFieldTableBuilder $builder, ParentModel $parentModel, Builder $query)
    {
        $query->leftJoin('customfields_parent', function ($join) {
            $join->on('customfields_custom_fields.id', '=', 'customfields_parent.cf_id');
        });
        $query->selectRaw("default_customfields_custom_fields.*, group_concat(default_customfields_parent.cat_id) as related")->groupBy('slug');

    }

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'sort_order' => 'ASC',
        ],
        'sortable' => true
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
