<?php namespace Visiosoft\CustomfieldsModule\Http\Controller\Admin;

use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\Form\CfvalueFormBuilder;
use Visiosoft\CustomfieldsModule\Cfvalue\Table\CfvalueTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\CustomfieldsModule\CustomField\CustomFieldModel;
use Visiosoft\CustomfieldsModule\Parent\Contract\ParentRepositoryInterface;

class CfvalueController extends AdminController
{
    /**
     * @var ParentRepositoryInterface
     */
    private $parent;

    /**
     * @var CategoryModel
     */
    private $category;

    /**
     * CfvalueController constructor.
     * @param ParentRepositoryInterface $parentRepository
     * @param CategoryModel $categoryModel
     */
    public function __construct(ParentRepositoryInterface $parentRepository, CategoryModel $categoryModel)
    {
        $this->parent = $parentRepository;
        $this->category = $categoryModel;
        parent::__construct();
    }

    /**
     * Display an index of existing entries.
     *
     * @param CfvalueTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(CfvalueTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param CfvalueFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(CfvalueFormBuilder $form, CustomFieldModel $customfields)
    {
        $customfieldType = [];
        $fields = $form->getFields();

        foreach ($customfields->selectableType() as $customfield) {
            $categories = $this->getParentCategories($customfield->id);

            //Add Categories Name
            if (count($categories)) {
                $categories_name = array();
                foreach ($categories as $category) {
                    $categories_name[] = $category->name;
                }
                $customfieldType[$customfield->id] = implode(',', $categories_name) . " >> " . $customfield->name;
            } else
                //All Category
                $customfieldType[$customfield->id] = trans('visiosoft.module.customfields::field.all') . " >> " .
                    $customfield->name;
        }

        $fields = array_merge([
            'custom_field' => [
                'type' => 'anomaly.field_type.select',
                'config' => [
                    'options' => $customfieldType,
                ],
            ]
        ], $fields);

        $form->setFields($fields);
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param CfvalueFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(CfvalueFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * @param $id
     * @return array
     */
    public function getParentCategories($id)
    {
        $categories = array();
        $parents = $this->parent->getByCustomFieldID($id);

        foreach ($parents as $parent) {
            $category = $this->category->find($parent->cat_id);
            if ($category)
                $categories[] = $category;
        }
        return $categories;
    }
}
